
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
hank_hours = m.addVar(name="hank_hours", lb=0)
mary_hours = m.addVar(name="mary_hours", lb=0)
bobby_hours = m.addVar(name="bobby_hours", lb=0)

# Set objective function
m.setObjective(6 * hank_hours + 7 * mary_hours + 2 * bobby_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(23.13 * hank_hours + 19.71 * mary_hours + 7.57 * bobby_hours >= 51, "c0")
m.addConstr(2 * hank_hours - 3 * bobby_hours >= 0, "c1")
m.addConstr(23.13 * hank_hours + 7.57 * bobby_hours <= 114, "c2")
m.addConstr(19.71 * mary_hours + 7.57 * bobby_hours <= 109, "c3")
m.addConstr(23.13 * hank_hours + 19.71 * mary_hours + 7.57 * bobby_hours <= 109, "c4")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('hank_hours: %g' % hank_hours.x)
    print('mary_hours: %g' % mary_hours.x)
    print('bobby_hours: %g' % bobby_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

