
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="hours_worked_by_Hank")
x1 = m.addVar(lb=0, name="hours_worked_by_Mary")
x2 = m.addVar(lb=0, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(6*x0 + 7*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(23.13*x0 + 19.71*x1 + 7.57*x2 >= 51, name="total_cost_constraint")
m.addConstr(2*x0 - 3*x2 >= 0, name="hank_bobby_hours_constraint")
m.addConstr(23.13*x0 + 7.57*x2 <= 114, name="hank_bobby_cost_constraint")
m.addConstr(19.71*x1 + 7.57*x2 <= 109, name="mary_bobby_cost_constraint")
m.addConstr(23.13*x0 + 19.71*x1 + 7.57*x2 <= 109, name="total_cost_constraint_all")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {x0.x}")
    print(f"Hours worked by Mary: {x1.x}")
    print(f"Hours worked by Bobby: {x2.x}")
else:
    print("No optimal solution found")
