
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Hank = m.addVar(name="hours_worked_by_Hank", lb=0)
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", lb=0)
hours_worked_by_Bobby = m.addVar(name="hours_worked_by_Bobby", lb=0)

# Define the coefficients
c_Hank = 6
c_Mary = 7
c_Bobby = 2

# Define the cost per hour
cost_per_hour_Hank = 23.13
cost_per_hour_Mary = 19.71
cost_per_hour_Bobby = 7.57

# Define the objective function
m.setObjective(c_Hank * hours_worked_by_Hank + c_Mary * hours_worked_by_Mary + c_Bobby * hours_worked_by_Bobby, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(cost_per_hour_Hank * hours_worked_by_Hank + cost_per_hour_Mary * hours_worked_by_Mary + cost_per_hour_Bobby * hours_worked_by_Bobby >= 51)
m.addConstr(2 * hours_worked_by_Hank - 3 * hours_worked_by_Bobby >= 0)
m.addConstr(cost_per_hour_Hank * hours_worked_by_Hank + cost_per_hour_Bobby * hours_worked_by_Bobby <= 114)
m.addConstr(cost_per_hour_Mary * hours_worked_by_Mary + cost_per_hour_Bobby * hours_worked_by_Bobby <= 109)
m.addConstr(cost_per_hour_Hank * hours_worked_by_Hank + cost_per_hour_Mary * hours_worked_by_Mary + cost_per_hour_Bobby * hours_worked_by_Bobby <= 109)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Hours worked by Bobby: {hours_worked_by_Bobby.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
