
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
calcium = m.addVar(lb=0, name="calcium")  # milligrams of calcium
vitamin_B5 = m.addVar(lb=0, name="vitamin_B5")  # milligrams of vitamin B5
vitamin_B3 = m.addVar(lb=0, name="vitamin_B3")  # milligrams of vitamin B3
fiber = m.addVar(lb=0, name="fiber")  # grams of fiber
vitamin_A = m.addVar(lb=0, name="vitamin_A")  # milligrams of vitamin A

# Define the objective function
m.setObjective(4 * calcium + 9 * vitamin_B5 + 7 * vitamin_B3 + 2 * fiber + vitamin_A, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstraint(3 * calcium <= 200)
m.addConstraint(4 * vitamin_B5 <= 200)
m.addConstraint(8 * vitamin_B3 <= 200)
m.addConstraint(8 * fiber <= 200)
m.addConstraint(11 * vitamin_A <= 200)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 >= 33)
m.addConstraint(8 * vitamin_B3 + 11 * vitamin_A >= 20)
m.addConstraint(8 * fiber + 11 * vitamin_A >= 37)
m.addConstraint(4 * vitamin_B5 + 8 * fiber >= 26)
m.addConstraint(3 * calcium + 8 * fiber >= 27)
m.addConstraint(3 * calcium + 11 * vitamin_A >= 19)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 11 * vitamin_A >= 21)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A >= 21)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 8 * fiber >= 21)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber >= 21)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 >= 21)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A >= 21)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 11 * vitamin_A >= 21)
m.addConstraint(4 * vitamin_B5 + 8 * fiber + 11 * vitamin_A >= 21)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber >= 21)
m.addConstraint(3 * calcium + 8 * fiber + 11 * vitamin_A >= 21)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 11 * vitamin_A >= 23)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A >= 23)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 8 * fiber >= 23)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber >= 23)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 >= 23)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A >= 23)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 11 * vitamin_A >= 23)
m.addConstraint(4 * vitamin_B5 + 8 * fiber + 11 * vitamin_A >= 23)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber >= 23)
m.addConstraint(3 * calcium + 8 * fiber + 11 * vitamin_A >= 23)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 11 * vitamin_A >= 27)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A >= 27)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 8 * fiber >= 27)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber >= 27)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 >= 27)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A >= 27)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 11 * vitamin_A >= 27)
m.addConstraint(4 * vitamin_B5 + 8 * fiber + 11 * vitamin_A >= 27)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber >= 27)
m.addConstraint(3 * calcium + 8 * fiber + 11 * vitamin_A >= 27)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 11 * vitamin_A >= 35)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A >= 35)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 8 * fiber >= 35)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber >= 35)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 >= 35)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A >= 35)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 11 * vitamin_A >= 35)
m.addConstraint(4 * vitamin_B5 + 8 * fiber + 11 * vitamin_A >= 35)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber >= 35)
m.addConstraint(3 * calcium + 8 * fiber + 11 * vitamin_A >= 35)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 11 * vitamin_A >= 26)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A >= 26)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 8 * fiber >= 26)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber >= 26)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 >= 26)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A >= 26)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 11 * vitamin_A >= 26)
m.addConstraint(4 * vitamin_B5 + 8 * fiber + 11 * vitamin_A >= 26)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber >= 26)
m.addConstraint(3 * calcium + 8 * fiber + 11 * vitamin_A >= 26)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 11 * vitamin_A >= 36)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A >= 36)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 8 * fiber >= 36)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber >= 36)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 >= 36)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A >= 36)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 11 * vitamin_A >= 36)
m.addConstraint(4 * vitamin_B5 + 8 * fiber + 11 * vitamin_A >= 36)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber >= 36)
m.addConstraint(3 * calcium + 8 * fiber + 11 * vitamin_A >= 36)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 11 * vitamin_A >= 28)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A >= 28)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 8 * fiber >= 28)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber >= 28)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 >= 28)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A >= 28)
m.addConstraint(3 * calcium + 8 * vitamin_B3 + 11 * vitamin_A >= 28)
m.addConstraint(4 * vitamin_B5 + 8 * fiber + 11 * vitamin_A >= 28)
m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber >= 28)
m.addConstraint(3 * calcium + 8 * fiber + 11 * vitamin_A >= 28)

m.addConstraint(4 * vitamin_B5 + 8 * vitamin_B3 <= 123)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * fiber <= 50)
m.addConstraint(8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A <= 160)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 11 * vitamin_A <= 183)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 <= 129)
m.addConstraint(3 * calcium + 4 * vitamin_B5 + 8 * vitamin_B3 + 8 * fiber + 11 * vitamin_A <= 129)

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    print("Milligrams of calcium:", calcium.varValue)
    print("Milligrams of vitamin B5:", vitamin_B5.varValue)
    print("Milligrams of vitamin B3:", vitamin_B3.varValue)
    print("Grams of fiber:", fiber.varValue)
    print("Milligrams of vitamin A:", vitamin_A.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
