
import gurobipy as gp

# Create a new model
m = gp.Model("Planting Optimization")

# Create variables
boxwoods = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")
roses = m.addVar(vtype=gp.GRB.INTEGER, name="roses")
begonias = m.addVar(vtype=gp.GRB.INTEGER, name="begonias")

# Set objective function
m.setObjective(8.66 * boxwoods + 8.39 * roses + 3.72 * begonias, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8.65 * boxwoods + 1.12 * roses + 0.8 * begonias >= 28 * 144, "min_planting_space") # 28 sq ft to sq in
m.addConstr(9.06 * boxwoods + 5.81 * begonias >= 32, "min_resilience_boxwoods_begonias")
m.addConstr(6.61 * roses + 5.81 * begonias >= 18, "min_resilience_roses_begonias")
m.addConstr(9.06 * boxwoods + 6.61 * roses + 5.81 * begonias >= 20, "min_resilience_total")
m.addConstr(8.65 * boxwoods + 0.8 * begonias <= 135 * 144, "max_planting_space_boxwoods_begonias") # 135 sq ft to sq in
m.addConstr(1.12 * roses + 0.8 * begonias <= 68 * 144, "max_planting_space_roses_begonias") # 68 sq ft to sq in
m.addConstr(8.65 * boxwoods + 1.12 * roses <= 128 * 144, "max_planting_space_boxwoods_roses") # 128 sq ft to sq in
m.addConstr(8.65 * boxwoods + 1.12 * roses + 0.8 * begonias <= 67 * 144, "max_planting_space_total_1") # 67 sq ft to sq in
m.addConstr(8.65 * boxwoods + 1.12 * roses + 0.8 * begonias <= 67 * 144, "max_planting_space_total_2") # 67 sq ft to sq in
m.addConstr(6.61 * roses + 5.81 * begonias <= 94, "max_resilience_roses_begonias")
m.addConstr(9.06 * boxwoods + 6.61 * roses <= 35, "max_resilience_boxwoods_roses")
m.addConstr(9.06 * boxwoods + 6.61 * roses + 5.81 * begonias <= 35, "max_resilience_total")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('boxwoods:', boxwoods.x)
    print('roses:', roses.x)
    print('begonias:', begonias.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

