
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    boxwoods = model.addVar(name="boxwoods", vtype=gurobi.GRB.INTEGER)
    roses = model.addVar(name="roses", vtype=gurobi.GRB.INTEGER)
    begonias = model.addVar(name="begonias", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8.66 * boxwoods + 8.39 * roses + 3.72 * begonias, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Planting space constraints
    model.addConstr(8.65 * boxwoods + 1.12 * roses + 0.8 * begonias >= 28 * 144)  # At least 28 sq. ft.
    model.addConstr(8.65 * boxwoods + 0.8 * begonias <= 135 * 144)  # Boxwoods and begonias at most 135 sq. ft.
    model.addConstr(1.12 * roses + 0.8 * begonias <= 68 * 144)  # Roses and begonias at most 68 sq. ft.
    model.addConstr(8.65 * boxwoods + 1.12 * roses <= 128 * 144)  # Boxwoods and roses at most 128 sq. ft.
    model.addConstr(8.65 * boxwoods + 1.12 * roses + 0.8 * begonias <= 67 * 144)  # All plants at most 67 sq. ft.

    # Resilience index constraints
    model.addConstr(9.06 * boxwoods + 5.81 * begonias >= 32)  # Boxwoods and begonias minimum 32
    model.addConstr(6.61 * roses + 5.81 * begonias >= 18)  # Roses and begonias minimum 18
    model.addConstr(9.06 * boxwoods + 6.61 * roses + 5.81 * begonias >= 20)  # All plants minimum 20
    model.addConstr(6.61 * roses + 5.81 * begonias <= 94)  # Roses and begonias maximum 94
    model.addConstr(9.06 * boxwoods + 6.61 * roses <= 35)  # Boxwoods and roses maximum 35
    model.addConstr(9.06 * boxwoods + 6.61 * roses + 5.81 * begonias <= 35)  # All plants maximum 35

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Boxwoods: {boxwoods.varValue}")
        print(f"Roses: {roses.varValue}")
        print(f"Begonias: {begonias.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
