
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
dale_hours = m.addVar(name="dale_hours")
peggy_hours = m.addVar(name="peggy_hours")
bill_hours = m.addVar(name="bill_hours")

# Set objective function
m.setObjective(1 * dale_hours + 3 * peggy_hours + 6 * bill_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(12 * peggy_hours + 11 * bill_hours >= 24, "c1")
m.addConstr(20 * dale_hours + 12 * peggy_hours >= 36, "c2")
m.addConstr(20 * dale_hours + 12 * peggy_hours + 11 * bill_hours >= 36, "c3")
m.addConstr(13 * dale_hours + 18 * bill_hours >= 15, "c4")
m.addConstr(15 * peggy_hours + 18 * bill_hours >= 33, "c5")
m.addConstr(13 * dale_hours + 15 * peggy_hours + 18 * bill_hours >= 23, "c6")
m.addConstr(10 * peggy_hours + 15 * bill_hours >= 32, "c7")
m.addConstr(20 * dale_hours + 10 * peggy_hours >= 23, "c8")
m.addConstr(20 * dale_hours + 10 * peggy_hours + 15 * bill_hours >= 24, "c9")
m.addConstr(-10 * peggy_hours + 10 * bill_hours >= 0, "c10")
m.addConstr(13 * dale_hours + 15 * peggy_hours <= 103, "c11")
m.addConstr(13 * dale_hours + 18 * bill_hours <= 66, "c12")
m.addConstr(13 * dale_hours + 15 * peggy_hours + 18 * bill_hours <= 115, "c13")
m.addConstr(10 * peggy_hours + 15 * bill_hours <= 95, "c14")
m.addConstr(20 * dale_hours + 15 * bill_hours <= 42, "c15")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Dale Hours: %g' % dale_hours.x)
    print('Peggy Hours: %g' % peggy_hours.x)
    print('Bill Hours: %g' % bill_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

