
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables
x0 = m.addVar(lb=0, name="hours_worked_by_Dale")
x1 = m.addVar(lb=0, name="hours_worked_by_Peggy")
x2 = m.addVar(lb=0, name="hours_worked_by_Bill")

# Objective function
m.setObjective(1*x0 + 3*x1 + 6*x2, GRB.MINIMIZE)

# Constraints
# Paperwork competence rating constraints
m.addConstr(12*x1 + 11*x2 >= 24)  # Total combined paperwork competence rating from Peggy and Bill
m.addConstr(20*x0 + 12*x1 >= 36)  # Total combined paperwork competence rating from Dale and Peggy
m.addConstr(20*x0 + 12*x1 + 11*x2 >= 36)  # Total combined paperwork competence rating from all

# Work quality rating constraints
m.addConstr(13*x0 + 18*x2 >= 15)  # Total combined work quality rating from Dale and Bill
m.addConstr(15*x1 + 18*x2 >= 33)  # Total combined work quality rating from Peggy and Bill
m.addConstr((13*x0 + 15*x1 + 18*x2) >= 23)  # Total combined work quality rating from all

# Dollar cost per hour constraints
m.addConstr(10*x1 + 15*x2 >= 32)  # Total combined dollar cost per hour from Peggy and Bill
m.addConstr(20*x0 + 10*x1 >= 23)  # Total combined dollar cost per hour from Dale and Peggy
m.addConstr((20*x0 + 10*x1 + 15*x2) >= 24)  # Total combined dollar cost per hour from all

# Additional constraints
m.addConstr(-10*x1 + 10*x2 >= 0)
m.addConstr(13*x0 + 15*x1 <= 103)  # Work quality rating from Dale and Peggy
m.addConstr((13*x0 + 18*x2) <= 66)  # Work quality rating from Dale and Bill
m.addConstr((13*x0 + 15*x1 + 18*x2) <= 115)  # Total combined work quality rating from all
m.addConstr(10*x1 + 15*x2 <= 95)  # Dollar cost per hour from Peggy and Bill
m.addConstr((20*x0 + 15*x2) <= 42)  # Dollar cost per hour from Dale and Bill

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Hours worked by Dale: {x0.x}, Peggy: {x1.x}, Bill: {x2.x}")
else:
    print("No optimal solution found.")
