
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_Dale", lb=0)  # hours worked by Dale
x1 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # hours worked by Peggy
x2 = m.addVar(name="hours_worked_by_Bill", lb=0)  # hours worked by Bill

# Define the objective function
m.setObjective(x0 + 3 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(12 * x1 + 11 * x2 >= 24)  # paperwork competence rating from Peggy and Bill
m.addConstr(20 * x0 + 12 * x1 >= 36)  # paperwork competence rating from Dale and Peggy
m.addConstr(20 * x0 + 12 * x1 + 11 * x2 >= 36)  # paperwork competence rating from all
m.addConstr(13 * x0 + 18 * x2 >= 15)  # work quality rating from Dale and Bill
m.addConstr(15 * x1 + 18 * x2 >= 33)  # work quality rating from Peggy and Bill
m.addConstr(13 * x0 + 15 * x1 + 18 * x2 >= 23)  # work quality rating from all
m.addConstr(10 * x1 + 15 * x2 >= 32)  # dollar cost per hour from Peggy and Bill
m.addConstr(20 * x0 + 10 * x1 >= 23)  # dollar cost per hour from Dale and Peggy
m.addConstr(20 * x0 + 10 * x1 + 15 * x2 >= 24)  # dollar cost per hour from all
m.addConstr(-10 * x1 + 10 * x2 >= 0)  # relationship between Peggy and Bill's hours
m.addConstr(13 * x0 + 15 * x1 <= 103)  # work quality rating limit from Dale and Peggy
m.addConstr(13 * x0 + 18 * x2 <= 66)  # work quality rating limit from Dale and Bill
m.addConstr(13 * x0 + 15 * x1 + 18 * x2 <= 115)  # work quality rating limit from all
m.addConstr(10 * x1 + 15 * x2 <= 95)  # dollar cost per hour limit from Peggy and Bill
m.addConstr(20 * x0 + 15 * x2 <= 42)  # dollar cost per hour limit from Dale and Bill

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x0.varValue}")
    print(f"Hours worked by Peggy: {x1.varValue}")
    print(f"Hours worked by Bill: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
