
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_E")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_calcium")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_C")

# Define the objective function
m.setObjective(5 * x0 + 1 * x1 + 8 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(28 * x0 + 25 * x1 <= 106)
m.addConstr(25 * x1 + 13 * x2 <= 70)
m.addConstr(28 * x0 + 25 * x1 + 13 * x2 <= 70)
m.addConstr(29 * x1 + 18 * x2 <= 148)
m.addConstr(19 * x0 + 29 * x1 <= 103)
m.addConstr(19 * x0 + 29 * x1 + 18 * x2 <= 103)
m.addConstr(24 * x0 + 29 * x1 + 6 * x2 >= 45)
m.addConstr(24 * x0 + 29 * x1 <= 137)
m.addConstr(24 * x0 + 6 * x2 <= 166)
m.addConstr(29 * x1 + 6 * x2 <= 192)
m.addConstr(24 * x0 + 29 * x1 + 6 * x2 <= 192)

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of vitamin E: {x0.X}")
    print(f"Milligrams of calcium: {x1.X}")
    print(f"Milligrams of vitamin C: {x2.X}")
else:
    print("No optimal solution found")
