
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams_of_vitamin_E", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="milligrams_of_calcium")
    x2 = model.addVar(name="milligrams_of_vitamin_C")

    # Objective function
    model.setObjective(5 * x0 + x1 + 8 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Total r2 >= 45
    model.addConstr(24 * x0 + 29 * x1 + 6 * x2 >= 45)

    # Total r0 from x0 and x1 <= 106
    model.addConstr(28 * x0 + 25 * x1 <= 106)

    # Total r0 from x1 and x2 <= 70
    model.addConstr(25 * x1 + 13 * x2 <= 70)

    # Total r0 from x0, x1, and x2 <= 70
    model.addConstr(28 * x0 + 25 * x1 + 13 * x2 <= 70)

    # Total r1 from x1 and x2 <= 148
    model.addConstr(29 * x1 + 18 * x2 <= 148)

    # Total r1 from x0 and x1 <= 103
    model.addConstr(19 * x0 + 29 * x1 <= 103)

    # Total r1 from x0, x1, and x2 <= 103
    model.addConstr(19 * x0 + 29 * x1 + 18 * x2 <= 103)

    # Total r2 from x0 and x1 <= 137
    model.addConstr(24 * x0 + 29 * x1 <= 137)

    # Total r2 from x0 and x2 <= 166
    model.addConstr(24 * x0 + 6 * x2 <= 166)

    # Total r2 from x1 and x2 <= 192
    model.addConstr(29 * x1 + 6 * x2 <= 192)

    # Total r2 from x0, x1, and x2 <= 192
    model.addConstr(24 * x0 + 29 * x1 + 6 * x2 <= 192)

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin E: {x0.varValue}")
        print(f"Milligrams of calcium: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
