
import gurobipy as gp

# Create a new model
m = gp.Model("Work_Optimization")

# Create variables
peggy = m.addVar(name="Peggy", lb=0.0)
bobby = m.addVar(name="Bobby", lb=0.0)
ringo = m.addVar(name="Ringo", lb=0.0)
laura = m.addVar(name="Laura", lb=0.0)

# Set objective function
m.setObjective(7 * peggy + 8 * bobby + 1 * ringo + 1 * laura, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * peggy + 13 * ringo + 11 * laura >= 32, "Dollar Cost 1")
m.addConstr(1 * peggy + 4 * bobby + 11 * laura >= 32, "Dollar Cost 2")
m.addConstr(1 * peggy + 4 * bobby + 13 * ringo >= 32, "Dollar Cost 3")

m.addConstr(12 * peggy + 11 * ringo >= 30, "Work Quality 1")
m.addConstr(10 * bobby + 10 * laura >= 23, "Work Quality 2")
m.addConstr(12 * peggy + 10 * bobby + 10 * laura >= 20, "Work Quality 3")

m.addConstr(1 * peggy + 4 * bobby <= 110, "Dollar Cost Upper Bound 1")
m.addConstr(13 * ringo + 11 * laura <= 54, "Dollar Cost Upper Bound 2")
m.addConstr(1 * peggy + 4 * bobby + 13 * ringo + 11 * laura <= 54, "Dollar Cost Upper Bound 3")

m.addConstr(12 * peggy + 10 * laura <= 98, "Work Quality Upper Bound 1")
m.addConstr(12 * peggy + 11 * ringo <= 50, "Work Quality Upper Bound 2")
m.addConstr(10 * bobby + 10 * laura <= 78, "Work Quality Upper Bound 3")
m.addConstr(11 * ringo + 10 * laura <= 110, "Work Quality Upper Bound 4")
m.addConstr(12 * peggy + 10 * bobby <= 32, "Work Quality Upper Bound 5")
m.addConstr(12 * peggy + 10 * bobby + 10 * laura <= 109, "Work Quality Upper Bound 6")
m.addConstr(12 * peggy + 10 * bobby + 11 * ringo + 10 * laura <= 109, "Work Quality Upper Bound 7")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

