
import gurobi as gp

# Create a new model
m = gp.Model()

# Define the variables
P = m.addVar(lb=0, name="hours_worked_by_Peggy")
B = m.addVar(lb=0, name="hours_worked_by_Bobby")
R = m.addVar(lb=0, name="hours_worked_by_Ringo")
L = m.addVar(lb=0, name="hours_worked_by_Laura")

# Define the objective function
m.setObjective(7 * P + 8 * B + R + L, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(1 * P + 4 * B + 13 * R + 11 * L >= 24)
m.addConstr(1 * P + 4 * B + 11 * L >= 24)
m.addConstr(1 * P + 4 * B + 13 * R >= 24)
m.addConstr(1 * P + 13 * R + 11 * L >= 18)
m.addConstr(1 * P + 4 * B + 11 * L >= 18)
m.addConstr(1 * P + 4 * B + 13 * R >= 18)
m.addConstr(1 * P + 13 * R + 11 * L >= 32)
m.addConstr(1 * P + 4 * B + 11 * L >= 32)
m.addConstr(1 * P + 4 * B + 13 * R >= 32)
m.addConstr(12 * P + 11 * R >= 30)
m.addConstr(10 * B + 10 * L >= 23)
m.addConstr(12 * P + 10 * B + 10 * L >= 20)
m.addConstr(1 * P + 4 * B <= 110)
m.addConstr(13 * R + 11 * L <= 54)
m.addConstr(1 * P + 4 * B + 13 * R + 11 * L <= 54)
m.addConstr(12 * P + 10 * L <= 98)
m.addConstr(12 * P + 11 * R <= 50)
m.addConstr(10 * B + 10 * L <= 78)
m.addConstr(11 * R + 10 * L <= 110)
m.addConstr(12 * P + 10 * B <= 32)
m.addConstr(12 * P + 10 * B + 10 * L <= 109)
m.addConstr(12 * P + 10 * B + 11 * R + 10 * L <= 109)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Peggy:", P.varValue)
    print("Hours worked by Bobby:", B.varValue)
    print("Hours worked by Ringo:", R.varValue)
    print("Hours worked by Laura:", L.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
