
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
fat = m.addVar(name="grams_of_fat", lb=0.0)  # Non-negative
calcium = m.addVar(name="milligrams_of_calcium", lb=0.0) # Non-negative

# Set objective function
m.setObjective(2 * fat + 6 * calcium, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * fat + 10 * calcium >= 42, "cardiovascular_support_min")
m.addConstr(14 * fat + 1 * calcium >= 49, "energy_stability_min")
m.addConstr(9 * fat - 8 * calcium >= 0, "custom_constraint")
m.addConstr(3 * fat + 10 * calcium <= 88, "cardiovascular_support_max") # Combined constraint
m.addConstr(14 * fat + 1 * calcium <= 62, "energy_stability_max") # Combined constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('grams_of_fat:', fat.x)
    print('milligrams_of_calcium:', calcium.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

