
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name='grams_of_fat')
x1 = m.addVar(vtype=GRB.CONTINUOUS, name='milligrams_of_calcium')

# Objective function: Maximize 2*x0 + 6*x1
m.setObjective(2*x0 + 6*x1, GRB.MAXIMIZE)

# Constraints
# Total combined cardiovascular support index >= 42
m.addConstr(3*x0 + 10*x1 >= 42, name='cardiovascular_support_min')

# Total combined energy stability index >= 49
m.addConstr(14*x0 + x1 >= 49, name='energy_stability_min')

# 9*x0 - 8*x1 >= 0
m.addConstr(9*x0 - 8*x1 >= 0, name='fat_calcium_ratio')

# Total combined cardiovascular support index <= 88
m.addConstr(3*x0 + 10*x1 <= 88, name='cardiovascular_support_max')

# Total combined energy stability index <= 62
m.addConstr(14*x0 + x1 <= 62, name='energy_stability_max')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of fat: {x0.x}")
    print(f"Milligrams of calcium: {x1.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found")
