
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
grams_of_fat = m.addVar(lb=0, name="grams_of_fat", vtype=gp.GRB.CONTINUOUS)
milligrams_of_calcium = m.addVar(lb=0, name="milligrams_of_calcium", vtype=gp.GRB.CONTINUOUS)

# Define the objective function
m.setObjective(2 * grams_of_fat + 6 * milligrams_of_calcium, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(3 * grams_of_fat >= 3, name="cardiovascular_support_index_fat")
m.addConstr(14 * grams_of_fat >= 14, name="energy_stability_index_fat")
m.addConstr(10 * milligrams_of_calcium >= 10, name="cardiovascular_support_index_calcium")
m.addConstr(milligrams_of_calcium >= 1, name="energy_stability_index_calcium") # Corrected constraint

# Corrected constraints for total indices
m.addConstr(3 * grams_of_fat + 10 * milligrams_of_calcium >= 42, name="total_cardiovascular_support_index_min")
m.addConstr(14 * grams_of_fat + milligrams_of_calcium >= 49, name="total_energy_stability_index_min")
m.addConstr(9 * grams_of_fat - 8 * milligrams_of_calcium >= 0, name="expression_constraint")

m.addConstr(3 * grams_of_fat + 10 * milligrams_of_calcium <= 88, name="total_cardiovascular_support_index_max")
m.addConstr(14 * grams_of_fat + milligrams_of_calcium <= 62, name="total_energy_stability_index_max")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Grams of Fat: {grams_of_fat.varValue}")
    print(f"Milligrams of Calcium: {milligrams_of_calcium.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible")
