
from gurobipy import *

# Create a model
m = Model("Nutrition_Optimization")

# Define variables
vitamin_A = m.addVar(lb=0, name="Vitamin_A", vtype=GRB.CONTINUOUS)
vitamin_K = m.addVar(lb=0, name="Vitamin_K", vtype=GRB.CONTINUOUS)
potassium = m.addVar(lb=0, name="Potassium", vtype=GRB.CONTINUOUS)
vitamin_B9 = m.addVar(lb=0, name="Vitamin_B9", vtype=GRB.CONTINUOUS)
carbohydrates = m.addVar(lb=0, name="Carbohydrates", vtype=GRB.CONTINUOUS)

# Objective function: For demonstration, let's assume we want to maximize the total combined cognitive performance index
m.setObjective(vitamin_A + vitamin_K + potassium + vitamin_B9 + carbohydrates, GRB.MAXIMIZE)

# Constraints
m.addConstr(-10 * potassium + 5 * vitamin_B9 >= 0)
m.addConstr(5 * vitamin_A - 7 * vitamin_B9 >= 0)

# Cognitive performance constraints (example)
m.addConstr(vitamin_K**2 + potassium**2 <= 55)
m.addConstr(vitamin_A + vitamin_K <= 18)
m.addConstr(vitamin_A + vitamin_K + carbohydrates <= 55)
m.addConstr(vitamin_A + vitamin_K + vitamin_B9 <= 24)

# Energy stability constraints (example)
m.addConstr(potassium**2 + carbohydrates**2 <= 33)
m.addConstr(potassium * vitamin_B9 <= 68)
m.addConstr(vitamin_A**2 + potassium**2 <= 27)
m.addConstr(vitamin_A + vitamin_B9 <= 65)

# Immune support constraints (example)
m.addConstr(vitamin_B9**2 + carbohydrates**2 <= 45)
m.addConstr(vitamin_A**2 + vitamin_B9**2 <= 123)
m.addConstr(vitamin_A + vitamin_K <= 96)
m.addConstr(vitamin_K**2 + carbohydrates**2 <= 144)

# Solve the model
m.optimize()

# Print results
print("Vitamin A:", vitamin_A.X)
print("Vitamin K:", vitamin_K.X)
print("Potassium:", potassium.X)
print("Vitamin B9:", vitamin_B9.X)
print("Carbohydrates:", carbohydrates.X)
