
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
agave = m.addVar(type=GRB.INTEGER, name="agave")
orange_trees = m.addVar(type=GRB.INTEGER, name="orange_trees")

# Set objective function
m.setObjective(2.08 * agave + 3.75 * orange_trees, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13 * agave + 15 * orange_trees >= 37, "resilience_lower_bound")
m.addConstr(9 * agave + 12 * orange_trees >= 42, "cost_lower_bound")
m.addConstr(-4 * agave + 7 * orange_trees >= 0, "agave_orange_relation")
m.addConstr(13 * agave + 15 * orange_trees <= 43, "resilience_upper_bound")  # Redundant constraint, but included for completeness
m.addConstr(9 * agave + 12 * orange_trees <= 85, "cost_upper_bound")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Number of agave: {agave.x}")
    print(f"Number of orange trees: {orange_trees.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

