
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
agave = m.addVar(vtype=GRB.INTEGER, name="agave")
orange_trees = m.addVar(vtype=GRB.INTEGER, name="orange_trees")

# Set the objective function
m.setObjective(2.08 * agave + 3.75 * orange_trees, GRB.MAXIMIZE)

# Add constraints
m.addConstr(13 * agave + 15 * orange_trees >= 37, "resilience_index_constraint")
m.addConstr(-4 * agave + 7 * orange_trees >= 0, "additional_constraint")
m.addConstr(9 * agave + 12 * orange_trees >= 42, "dollar_cost_lower_bound")
m.addConstr(9 * agave + 12 * orange_trees <= 85, "dollar_cost_upper_bound")
m.addConstr(13 * agave + 15 * orange_trees <= 43, "resilience_index_upper_bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Agave:", agave.x)
    print("Orange Trees:", orange_trees.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
