
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
agave = m.addVar(name="agave", vtype=gp.GRB.INTEGER)
orange_trees = m.addVar(name="orange_trees", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(2.08 * agave + 3.75 * orange_trees, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(13 * agave + 15 * orange_trees >= 37, name="resilience_index_min")
m.addConstr(13 * agave + 15 * orange_trees <= 43, name="resilience_index_max")
m.addConstr(9 * agave + 12 * orange_trees >= 42, name="cost_min")
m.addConstr(9 * agave + 12 * orange_trees <= 85, name="cost_max")
m.addConstr(-4 * agave + 7 * orange_trees >= 0, name="agave_orange_relationship")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Agave: {agave.varValue}")
    print(f"Orange Trees: {orange_trees.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
