
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
tomatoes = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tomatoes")
cornichons = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
steaks = model.addVar(lb=0, vtype=GRB.INTEGER, name="steaks")
strawberries = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="strawberries")

# Set objective function
obj = 5*tomatoes**2 + 9*tomatoes*cornichons + 6*tomatoes*steaks + 5*tomatoes*strawberries + 2*cornichons**2 + 3*cornichons*steaks + 2*steaks**2 + 8*steaks*strawberries + 3*strawberries**2 + 2*tomatoes + 4*cornichons + 5*steaks + 4*strawberries

model.setObjective(obj, GRB.MINIMIZE)

# Add constraints
model.addConstr(11*tomatoes + 17*cornichons + 16*steaks + 5*strawberries <= 562, "iron_upper_bound") # Resource constraint
model.addConstr(11*tomatoes**2 + 17*cornichons**2 >= 98, "iron_from_tomatoes_cornichons_squared")
model.addConstr(17*cornichons + 16*steaks >= 123, "iron_from_cornichons_steaks")
model.addConstr(16*steaks + 5*strawberries >= 72, "iron_from_steaks_strawberries")
model.addConstr(17*cornichons + 5*strawberries >= 114, "iron_from_cornichons_strawberries")
model.addConstr(11*tomatoes + 16*steaks >= 49, "iron_from_tomatoes_steaks")
model.addConstr(11*tomatoes + 17*cornichons + 16*steaks + 5*strawberries >= 49, "iron_from_all")
model.addConstr(-tomatoes**2 + 9*strawberries**2 >= 0, "tomatoes_strawberries_squared")
model.addConstr(17*cornichons**2 + 16*steaks**2 <= 489, "cornichons_steaks_squared_upper_bound")
model.addConstr(11*tomatoes + 16*steaks + 5*strawberries <= 516, "tomatoes_steaks_strawberries_upper_bound")
model.addConstr(11*tomatoes**2 + 17*cornichons**2 + 16*steaks**2 <= 373, "tomatoes_cornichons_steaks_squared_upper_bound")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('tomatoes:', tomatoes.x)
    print('cornichons:', cornichons.x)
    print('steaks:', steaks.x)
    print('strawberries:', strawberries.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

