
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    tomatoes = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="tomatoes")
    cornichons = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="cornichons")
    steaks = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, integrality=gurobi.GRB.INTEGER, name="steaks")
    strawberries = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="strawberries")

    # Objective function
    model.setObjective(5 * tomatoes**2 + 9 * tomatoes * cornichons + 6 * tomatoes * steaks + 5 * tomatoes * strawberries +
                       2 * cornichons**2 + 3 * cornichons * steaks + 2 * steaks**2 + 8 * steaks * strawberries +
                       3 * strawberries**2 + 2 * tomatoes + 4 * cornichons + 5 * steaks + 4 * strawberries,
                       gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(121 * tomatoes**2 + 289 * cornichons**2 >= 98, name="iron_tomatoes_cornichons")
    model.addConstr(17 * cornichons + 16 * steaks >= 123, name="iron_cornichons_steaks")
    model.addConstr(16 * steaks + 5 * strawberries >= 72, name="iron_steaks_strawberries")
    model.addConstr(17 * cornichons + 5 * strawberries >= 114, name="iron_cornichons_strawberries")
    model.addConstr(11 * tomatoes + 16 * steaks >= 49, name="iron_tomatoes_steaks")
    model.addConstr(11 * tomatoes + 17 * cornichons + 16 * steaks + 5 * strawberries >= 49, name="iron_all")
    model.addConstr(-tomatoes**2 + 9 * strawberries**2 >= 0, name="strawberries_vs_tomatoes")
    model.addConstr(289 * cornichons**2 + 256 * steaks**2 <= 489, name="iron_cornichons_steaks_limit")
    model.addConstr(11 * tomatoes + 16 * steaks + 5 * strawberries <= 516, name="iron_tomatoes_steaks_strawberries_limit")
    model.addConstr(121 * tomatoes**2 + 289 * cornichons**2 + 256 * steaks**2 <= 373, name="iron_all_limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Tomatoes: ", tomatoes.varValue)
        print("Cornichons: ", cornichons.varValue)
        print("Steaks: ", steaks.varValue)
        print("Strawberries: ", strawberries.varValue)
    else:
        print("Model is infeasible")

optimize_problem()
