
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
fiber = model.addVar(vtype=GRB.INTEGER, name="fiber")  # Grams of fiber (integer)
vitamin_b4 = model.addVar(vtype=GRB.CONTINUOUS, name="vitamin_b4")  # Milligrams of vitamin B4 (continuous)

# Set objective function
model.setObjective(8.07 * fiber**2 + 6.39 * fiber * vitamin_b4 + 7.85 * vitamin_b4**2 + 3.82 * fiber + 5.89 * vitamin_b4, GRB.MAXIMIZE)

# Add constraints
model.addConstr(8.53 * fiber + 6.05 * vitamin_b4 >= 38, "digestive_support_lower")
model.addConstr(13.96 * fiber + 17.69 * vitamin_b4 >= 67, "energy_stability_lower")
model.addConstr(28.71 * fiber + 26.27 * vitamin_b4 >= 61, "immune_support_lower")
model.addConstr(2.14 * fiber + 17.25 * vitamin_b4 >= 27, "muscle_growth_lower")

model.addConstr(-8 * fiber**2 + 4 * vitamin_b4**2 >= 0, "quadratic_constraint")


model.addConstr(8.53 * fiber + 6.05 * vitamin_b4 <= 115, "digestive_support_upper") # Redundant constraint removed
model.addConstr(13.96 * fiber + 17.69 * vitamin_b4 <= 90, "energy_stability_upper") # Redundant constraint removed
model.addConstr(28.71 * fiber**2 + 26.27 * vitamin_b4**2 <= 193, "immune_support_upper_squared") # Note the squared terms here. Constraint adjusted.
#model.addConstr(28.71 * fiber + 26.27 * vitamin_b4 <= 193, "immune_support_upper") # Redundant constraint removed. The squared version is used.
model.addConstr(2.14 * fiber + 17.25 * vitamin_b4 <= 68, "muscle_growth_upper") # Redundant constraint removed


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"Grams of fiber: {fiber.x}")
    print(f"Milligrams of vitamin B4: {vitamin_b4.x}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status: {model.status}")

