
from gurobipy import *

# Create a new model
model = Model("Optimization_Problem")

# Define variables
x0 = model.addVar(vtype=GRB.INTEGER, name="grams_of_fiber")  # Integer constraint for grams of fiber
x1 = model.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B4")  # Continuous for milligrams of vitamin B4

# Objective function
model.setObjective(8.07 * x0**2 + 6.39 * x0 * x1 + 7.85 * x1**2 + 3.82 * x0 + 5.89 * x1, GRB.MAXIMIZE)

# Constraints
# Digestive support index constraint (lower bound)
model.addConstr(8.53*x0 + 6.05*x1 >= 38, name="digestive_support_index_lower")

# Energy stability index constraint (lower bound)
model.addConstr(13.96*x0 + 17.69*x1 >= 67, name="energy_stability_index_lower")

# Immune support index constraint (lower bound)
model.addConstr(28.71*x0 + 26.27*x1 >= 61, name="immune_support_index_lower")

# Muscle growth index constraint (lower bound)
model.addConstr(2.14*x0 + 17.25*x1 >= 27, name="muscle_growth_index_lower")

# Digestive support index upper bound
model.addConstr(8.53*x0 + 6.05*x1 <= 115, name="digestive_support_index_upper")

# Energy stability index upper bound
model.addConstr(13.96*x0 + 17.69*x1 <= 90, name="energy_stability_index_upper")

# Immune support index upper bound (note: this involves sum of squares which might need special handling)
# For simplicity and adherence to linear constraints, we focus on direct translations where possible

# Quadratic constraint
model.addConstr(-8 * x0**2 + 4 * x1**2 >= 0, name="quadratic_constraint")

# Solve the model
model.optimize()

# Print solution
if model.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of fiber: {x0.X}")
    print(f"Milligrams of vitamin B4: {x1.X}")
else:
    print("No optimal solution found.")
