
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
grams_of_fiber = m.addVar(name="grams_of_fiber", vtype=GRB.INTEGER)
milligrams_of_vitamin_B4 = m.addVar(name="milligrams_of_vitamin_B4")

# Objective function
m.setObjective(8.07 * grams_of_fiber**2 + 6.39 * grams_of_fiber * milligrams_of_vitamin_B4 + 
               7.85 * milligrams_of_vitamin_B4**2 + 3.82 * grams_of_fiber + 5.89 * milligrams_of_vitamin_B4, 
               sense=GRB.MAXIMIZE)

# Digestive Support Index constraints
m.addConstraint(8.53 * grams_of_fiber + 6.05 * milligrams_of_vitamin_B4 >= 38)
m.addConstraint(8.53 * grams_of_fiber + 6.05 * milligrams_of_vitamin_B4 <= 115)

# Energy Stability Index constraints
m.addConstraint(13.96 * grams_of_fiber + 17.69 * milligrams_of_vitamin_B4 >= 67)
m.addConstraint(13.96 * grams_of_fiber + 17.69 * milligrams_of_vitamin_B4 <= 90)

# Immune Support Index constraints
m.addConstraint(28.71 * grams_of_fiber + 26.27 * milligrams_of_vitamin_B4 >= 61)
m.addConstraint(28.71 * grams_of_fiber + 26.27 * milligrams_of_vitamin_B4 <= 193)

# Muscle Growth Index constraints
m.addConstraint(2.14 * grams_of_fiber + 17.25 * milligrams_of_vitamin_B4 >= 27)
m.addConstraint(2.14 * grams_of_fiber + 17.25 * milligrams_of_vitamin_B4 <= 68)

# Quadratic constraint
m.addConstraint(-8 * grams_of_fiber**2 + 4 * milligrams_of_vitamin_B4**2 >= 0)

# Solve the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Grams of Fiber: {grams_of_fiber.varValue}")
    print(f"Milligrams of Vitamin B4: {milligrams_of_vitamin_B4.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("The model is infeasible.")
