
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
ramen = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="ramen")
granola = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola")
beans = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="beans")
burgers = m.addVar(lb=0, vtype=GRB.INTEGER, name="burgers")

# Set objective function
m.setObjective(7.17 * ramen**2 + 7.28 * granola**2 + 4.4 * granola * beans + 4.41 * beans * burgers, GRB.MAXIMIZE)

# Add protein constraints
m.addConstr(6 * ramen + 15 * burgers >= 22, "protein_constraint1")
m.addConstr(6 * ramen + 2 * beans >= 14, "protein_constraint2")
m.addConstr(6 * ramen**2 + 16 * granola**2 + 2 * beans**2 >= 21, "protein_constraint3")
m.addConstr(6 * ramen + 16 * granola + 15 * burgers >= 21, "protein_constraint4")
m.addConstr(6 * ramen**2 + 16 * granola**2 + 2 * beans**2 >= 18, "protein_constraint5")
m.addConstr(6 * ramen + 16 * granola + 15 * burgers >= 18, "protein_constraint6")
m.addConstr(2 * beans**2 + 15 * burgers**2 <= 87, "protein_constraint7")
m.addConstr(6 * ramen**2 + 15 * burgers**2 <= 74, "protein_constraint8")
m.addConstr(16 * granola**2 + 2 * beans**2 <= 66, "protein_constraint9")
m.addConstr(6 * ramen**2 + 16 * granola**2 <= 95, "protein_constraint10")
m.addConstr(6 * ramen + 16 * granola + 2 * beans + 15 * burgers <= 95, "protein_constraint11")


# Add carbohydrate constraints
m.addConstr(14 * ramen + 16 * burgers >= 29, "carb_constraint1")
m.addConstr(14 * ramen + 4 * granola >= 21, "carb_constraint2")
m.addConstr(14 * ramen + 4 * granola + 10 * beans >= 23, "carb_constraint3")
m.addConstr(14 * ramen**2 + 4 * granola**2 <= 93, "carb_constraint4")
m.addConstr(14 * ramen**2 + 10 * beans**2 <= 110, "carb_constraint5")
m.addConstr(4 * granola + 16 * burgers <= 100, "carb_constraint6")
m.addConstr(4 * granola + 10 * beans <= 139, "carb_constraint7")
m.addConstr(14 * ramen**2 + 4 * granola**2 + 10 * beans**2 <= 119, "carb_constraint8")
m.addConstr(4 * granola**2 + 10 * beans**2 + 16 * burgers**2 <= 117, "carb_constraint9")
m.addConstr(14 * ramen + 4 * granola + 16 * burgers <= 126, "carb_constraint10")
m.addConstr(14 * ramen + 4 * granola + 10 * beans + 16 * burgers <= 126, "carb_constraint11")


# Add resource constraints based on the provided dictionary (optional, if applicable)
resource_data = {'r0': {'description': 'grams of protein', 'upper_bound': 120, 'x0': 6, 'x1': 16, 'x2': 2, 'x3': 15}, 'r1': {'description': 'grams of carbohydrates', 'upper_bound': 140, 'x0': 14, 'x1': 4, 'x2': 10, 'x3': 16}}
for resource, data in resource_data.items():
    m.addConstr(data['x0'] * ramen + data['x1'] * granola + data['x2'] * beans + data['x3'] * burgers <= data['upper_bound'], resource)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

