
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="bowls_of_instant_ramen")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="granola_bars")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="green_beans")
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="hamburgers")

    # Objective function
    model.setObjective(7.17 * x0**2 + 7.28 * x1**2 + 4.4 * x1 * x2 + 4.41 * x2 * x3, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(6 * x0 + 15 * x3 >= 22)
    model.addConstr(6 * x0 + 2 * x2 >= 14)
    model.addConstr(6**2 * x0**2 + 16**2 * x1**2 + 2**2 * x2**2 >= 21)
    model.addConstr(6 * x0 + 16 * x1 + 15 * x3 >= 21)
    model.addConstr(6**2 * x0**2 + 16**2 * x1**2 + 2**2 * x2**2 >= 18)
    model.addConstr(6 * x0 + 16 * x1 + 15 * x3 >= 18)
    model.addConstr(14 * x0 + 16 * x3 >= 29)
    model.addConstr(14 * x0 + 4 * x1 >= 21)
    model.addConstr(14 * x0 + 4 * x1 + 10 * x2 >= 23)
    model.addConstr(2**2 * x2**2 + 15**2 * x3**2 <= 87)
    model.addConstr(6**2 * x0**2 + 15**2 * x3**2 <= 74)
    model.addConstr(16**2 * x1**2 + 2**2 * x2**2 <= 66)
    model.addConstr(6**2 * x0**2 + 16**2 * x1**2 <= 95)
    model.addConstr(6 * x0 + 16 * x1 + 2 * x2 + 15 * x3 <= 95)
    model.addConstr(14**2 * x0**2 + 4**2 * x1**2 <= 93)
    model.addConstr(14**2 * x0**2 + 10**2 * x2**2 <= 110)
    model.addConstr(4 * x1 + 16 * x3 <= 100)
    model.addConstr(4 * x1 + 10 * x2 <= 139)
    model.addConstr(14**2 * x0**2 + 4**2 * x1**2 + 10**2 * x2**2 <= 119)
    model.addConstr(4**2 * x1**2 + 10**2 * x2**2 + 16**2 * x3**2 <= 117)
    model.addConstr(14 * x0 + 4 * x1 + 16 * x3 <= 126)
    model.addConstr(14 * x0 + 4 * x1 + 10 * x2 + 16 * x3 <= 126)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("bowls_of_instant_ramen: ", x0.varValue)
        print("granola_bars: ", x1.varValue)
        print("green_beans: ", x2.varValue)
        print("hamburgers: ", x3.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
