
import gurobipy as gp

# Create a new model
m = gp.Model("Employee_Scheduling")

# Create variables
hank = m.addVar(lb=0, name="hank")
peggy = m.addVar(lb=0, name="peggy")
dale = m.addVar(lb=0, name="dale")
laura = m.addVar(lb=0, name="laura")

# Set objective function
m.setObjective(3 * hank + 1 * peggy + 1 * dale + 6 * laura, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9.78 * hank + 10.71 * peggy >= 6, "c1")
m.addConstr(10.71 * peggy + 0.25 * laura >= 6, "c2")
m.addConstr(9.78 * hank + 0.25 * laura >= 18, "c3")
m.addConstr(9.78 * hank + 1.77 * dale >= 11, "c4")
m.addConstr(9.78 * hank + 10.71 * peggy + 1.77 * dale + 0.25 * laura >= 11, "c5")
m.addConstr(9.7 * hank + 5.48 * laura >= 8, "c6")
m.addConstr(7.36 * peggy + 6.5 * dale >= 16, "c7")
m.addConstr(9.7 * hank + 6.5 * dale >= 19, "c8")
m.addConstr(6.5 * dale + 5.48 * laura >= 12, "c9")
m.addConstr(7.36 * peggy + 5.48 * laura >= 15, "c10")
m.addConstr(7.36 * peggy + 6.5 * dale + 5.48 * laura >= 9, "c11")
m.addConstr(9.7 * hank + 7.36 * peggy + 6.5 * dale >= 9, "c12")
m.addConstr(7.36 * peggy + 6.5 * dale + 5.48 * laura >= 17, "c13")
m.addConstr(9.7 * hank + 7.36 * peggy + 6.5 * dale >= 17, "c14")
m.addConstr(9.7 * hank + 7.36 * peggy + 6.5 * dale + 5.48 * laura >= 17, "c15")
m.addConstr(1.73 * hank + 7.28 * laura >= 15, "c16")
m.addConstr(1.73 * hank + 5.19 * peggy >= 8, "c17")
m.addConstr(5.19 * peggy + 7.26 * dale >= 14, "c18")
m.addConstr(1.73 * hank + 7.26 * dale >= 15, "c19")
m.addConstr(1.73 * hank + 5.19 * peggy + 7.26 * dale + 7.28 * laura >= 15, "c20")
m.addConstr(1 * hank - 8 * dale >= 0, "c21")
m.addConstr(10.71 * peggy + 0.25 * laura <= 28, "c22")
m.addConstr(6.5 * dale + 5.48 * laura <= 72, "c23")
m.addConstr(9.7 * hank + 5.48 * laura <= 58, "c24")
m.addConstr(7.36 * peggy + 5.48 * laura <= 25, "c25")
m.addConstr(9.7 * hank + 7.36 * peggy <= 39, "c26")
m.addConstr(1.73 * hank + 7.26 * dale <= 30, "c27")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

