
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    H = model.addVar(lb=0, name="H")  # hours worked by Hank
    P = model.addVar(lb=0, name="P")  # hours worked by Peggy
    D = model.addVar(lb=0, name="D")  # hours worked by Dale
    L = model.addVar(lb=0, name="L")  # hours worked by Laura

    # Objective function
    model.setObjective(3*H + P + D + 6*L + 1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9.78*H + 10.71*P >= 6)
    model.addConstr(10.71*P + 0.25*L >= 6)
    model.addConstr(9.78*H + 0.25*L >= 18)
    model.addConstr(9.78*H + 1.77*D >= 11)
    model.addConstr(9.78*H + 10.71*P + 1.77*D + 0.25*L >= 11)
    model.addConstr(9.7*H + 5.48*L >= 8)
    model.addConstr(7.36*P + 6.5*D >= 16)
    model.addConstr(9.7*H + 6.5*D >= 19)
    model.addConstr(6.5*D + 5.48*L >= 12)
    model.addConstr(7.36*P + 5.48*L >= 15)
    model.addConstr(7.36*P + 6.5*D + 5.48*L >= 9)
    model.addConstr(9.7*H + 7.36*P + 6.5*D >= 9)
    model.addConstr(7.36*P + 6.5*D + 5.48*L >= 17)
    model.addConstr(9.7*H + 7.36*P + 6.5*D >= 17)
    model.addConstr(9.7*H + 7.36*P + 6.5*D + 5.48*L >= 17)
    model.addConstr(1.73*H + 7.28*L >= 15)
    model.addConstr(1.73*H + 5.19*P >= 8)
    model.addConstr(5.19*P + 7.26*D >= 14)
    model.addConstr(1.73*H + 7.26*D >= 15)
    model.addConstr(1.73*H + 5.19*P + 7.26*D + 7.28*L >= 15)
    model.addConstr(H - 8*D >= 0)
    model.addConstr(10.71*P + 0.25*L <= 28)
    model.addConstr(6.5*D + 5.48*L <= 72)
    model.addConstr(9.7*H + 5.48*L <= 58)
    model.addConstr(7.36*P + 5.48*L <= 25)
    model.addConstr(9.7*H + 7.36*P <= 39)
    model.addConstr(1.73*H + 7.26*D <= 30)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("H: ", H.varValue)
        print("P: ", P.varValue)
        print("D: ", D.varValue)
        print("L: ", L.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
