
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
Mbps_bandwidth = m.addVar(name="Mbps_bandwidth_allocated_to_monitoring", vtype=gp.GRB.INTEGER)
patches_per_day = m.addVar(name="patches_per_day", vtype=gp.GRB.INTEGER)
network_administrators = m.addVar(name="network_administrators", vtype=gp.GRB.INTEGER)
system_administrators = m.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)
intrusion_analysts = m.addVar(name="intrusion_analysts", vtype=gp.GRB.INTEGER)
security_engineers = m.addVar(name="security_engineers", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(2 * Mbps_bandwidth + patches_per_day + 6 * network_administrators + 9 * system_administrators + 8 * intrusion_analysts + 3 * security_engineers, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(1 * patches_per_day + 5 * security_engineers >= 30)
m.addConstr(21 * Mbps_bandwidth + 23 * system_administrators >= 63)
m.addConstr(23 * system_administrators + 5 * security_engineers >= 63)
m.addConstr(1 * patches_per_day + 9 * network_administrators >= 50)
m.addConstr(21 * Mbps_bandwidth + 1 * patches_per_day >= 43)
m.addConstr(15 * intrusion_analysts + 5 * security_engineers >= 52)
m.addConstr(9 * network_administrators + 23 * system_administrators >= 46)
m.addConstr(21 * Mbps_bandwidth + 15 * intrusion_analysts >= 55)
m.addConstr(21 * Mbps_bandwidth + 1 * patches_per_day + 9 * network_administrators + 23 * system_administrators + 15 * intrusion_analysts + 5 * security_engineers >= 55)
m.addConstr(-3 * network_administrators + 3 * security_engineers >= 0)
m.addConstr(1 * patches_per_day + 9 * network_administrators <= 354)
m.addConstr(21 * Mbps_bandwidth + 1 * patches_per_day <= 299)
m.addConstr(1 * patches_per_day + 5 * security_engineers <= 410)
m.addConstr(21 * Mbps_bandwidth + 15 * intrusion_analysts <= 379)
m.addConstr(21 * Mbps_bandwidth + 15 * intrusion_analysts + 5 * security_engineers <= 265)
m.addConstr(9 * network_administrators + 15 * intrusion_analysts + 5 * security_engineers <= 143)
m.addConstr(21 * Mbps_bandwidth + 1 * patches_per_day + 23 * system_administrators <= 272)
m.addConstr(1 * patches_per_day + 23 * system_administrators + 15 * intrusion_analysts <= 352)
m.addConstr(21 * Mbps_bandwidth + 23 * system_administrators + 15 * intrusion_analysts <= 144)
m.addConstr(9 * network_administrators + 23 * system_administrators + 15 * intrusion_analysts <= 247)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Mbps bandwidth allocated to monitoring: {Mbps_bandwidth.varValue}")
    print(f"Patches per day: {patches_per_day.varValue}")
    print(f"Network administrators: {network_administrators.varValue}")
    print(f"System administrators: {system_administrators.varValue}")
    print(f"Intrusion analysts: {intrusion_analysts.varValue}")
    print(f"Security engineers: {security_engineers.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
