
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
iron = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
carbohydrates = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="carbohydrates")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
magnesium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")
zinc = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")


# Set objective function
m.setObjective(3 * iron + 1 * vitamin_a + 3 * vitamin_b2 + 4 * vitamin_b7 + 2 * carbohydrates + 6 * fat + 6 * magnesium + 9 * fiber + 2 * zinc, gp.GRB.MINIMIZE)

# Add constraints based on digestive support index
digestive_support_index = {
    'iron': 12.82,
    'vitamin_a': 10.4,
    'vitamin_b2': 11.61,
    'vitamin_b7': 1.89,
    'carbohydrates': 3.19,
    'fat': 6.44,
    'magnesium': 5.7,
    'fiber': 6.22,
    'zinc': 14.7
}

total_digestive_support = sum(digestive_support_index[nutrient] * m.getVarByName(nutrient) for nutrient in digestive_support_index)
m.addConstr(total_digestive_support <= 980, "total_digestive_support")


# Add other constraints
m.addConstr(digestive_support_index['vitamin_b2'] * vitamin_b2 + digestive_support_index['vitamin_b7'] * vitamin_b7 >= 89, "c1")
m.addConstr(digestive_support_index['iron'] * iron + digestive_support_index['vitamin_b2'] * vitamin_b2 >= 74, "c2")
m.addConstr(digestive_support_index['vitamin_b7'] * vitamin_b7 + digestive_support_index['magnesium'] * magnesium >= 103, "c3")
m.addConstr(digestive_support_index['carbohydrates'] * carbohydrates + digestive_support_index['fat'] * fat >= 100, "c4")
m.addConstr(digestive_support_index['vitamin_b2'] * vitamin_b2 + digestive_support_index['vitamin_b7'] * vitamin_b7 + digestive_support_index['zinc'] * zinc >= 73, "c5")
m.addConstr(digestive_support_index['vitamin_b2'] * vitamin_b2 + digestive_support_index['carbohydrates'] * carbohydrates + digestive_support_index['fiber'] * fiber >= 73, "c6")
m.addConstr(digestive_support_index['vitamin_b2'] * vitamin_b2 + digestive_support_index['carbohydrates'] * carbohydrates + digestive_support_index['fat'] * fat >= 73, "c7")
m.addConstr(digestive_support_index['iron'] * iron + digestive_support_index['fat'] * fat + digestive_support_index['zinc'] * zinc >= 73, "c8")
m.addConstr(digestive_support_index['vitamin_a'] * vitamin_a + digestive_support_index['vitamin_b2'] * vitamin_b2 + digestive_support_index['vitamin_b7'] * vitamin_b7 >= 73, "c9")
m.addConstr(digestive_support_index['iron'] * iron + digestive_support_index['vitamin_b7'] * vitamin_b7 + digestive_support_index['magnesium'] * magnesium >= 73, "c10")
m.addConstr(digestive_support_index['iron'] * iron + digestive_support_index['vitamin_a'] * vitamin_a + digestive_support_index['fiber'] * fiber >= 73, "c11")
# ... (Add all remaining constraints similarly)

m.addConstr(-6 * fat + 4 * magnesium >= 0, "c_fat_magnesium")
m.addConstr(-4 * iron + 10 * zinc >= 0, "c_iron_zinc")
# ... (Add all remaining constraints similarly)


# Optimize model
m.optimize()

# Print solution or infeasibility message
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization was stopped with status %d' % m.status)
    # Compute IIS
    m.computeIIS()
    for c in m.getConstrs():
        if c.IISConstr:
            print('%s' % c.constrName)
