
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
ramen = m.addVar(vtype=GRB.INTEGER, name="ramen")
steaks = m.addVar(vtype=GRB.INTEGER, name="steaks")
sandwiches = m.addVar(vtype=GRB.INTEGER, name="sandwiches")
granola = m.addVar(vtype=GRB.INTEGER, name="granola")

# Set objective function
m.setObjective(3.62*ramen*ramen + 4.63*ramen*steaks + 5.03*ramen*granola + 2.07*steaks*steaks + 6.03*steaks*sandwiches + 3.6*steaks*granola + 6.97*sandwiches*sandwiches + 7.45*sandwiches*granola + 4.02*granola*granola + 9.15*ramen + 9.81*steaks + 8.4*granola, GRB.MAXIMIZE)

# Add constraints based on resources/attributes
m.addConstr(3.51*ramen + 0.65*steaks + 8.37*sandwiches + 1.67*granola <= 139, "protein_limit") # r0
m.addConstr(1.79*ramen + 5.28*steaks + 7.08*sandwiches + 7.75*granola <= 203, "carbohydrate_limit") # r1
m.addConstr(7.74*ramen + 7.25*steaks + 6.01*sandwiches + 7.62*granola <= 161, "tastiness_limit") # r2

# Add additional constraints
m.addConstr(7.74*ramen + 6.01*sandwiches >= 29, "tastiness_min")
m.addConstr(8.37*sandwiches*sandwiches + 1.67*granola*granola <= 44, "protein_squared")
m.addConstr(3.51*ramen + 0.65*steaks <= 59, "protein_ramen_steaks")
m.addConstr(3.51*ramen + 8.37*sandwiches <= 104, "protein_ramen_sandwiches")
m.addConstr(0.65*steaks*steaks + 1.67*granola*granola <= 95, "protein_steaks_granola")
m.addConstr(3.51*ramen + 0.65*steaks + 8.37*sandwiches <= 65, "protein_ramen_steaks_sandwiches")
m.addConstr(3.51*ramen + 0.65*steaks + 8.37*sandwiches + 1.67*granola <= 65, "protein_total")
m.addConstr(5.28*steaks*steaks + 7.08*sandwiches*sandwiches <= 59, "carbohydrate_steaks_sandwiches")
m.addConstr(1.79*ramen + 7.08*sandwiches <= 56, "carbohydrate_ramen_sandwiches")
m.addConstr(1.79*ramen + 5.28*steaks <= 109, "carbohydrate_ramen_steaks")
m.addConstr(5.28*steaks*steaks + 7.75*granola*granola <= 85, "carbohydrate_steaks_granola")
m.addConstr(1.79*ramen + 5.28*steaks + 7.08*sandwiches + 7.75*granola <= 85, "carbohydrate_total")
m.addConstr(7.74*ramen + 6.01*sandwiches <= 140, "tastiness_ramen_sandwiches")
m.addConstr(7.74*ramen*ramen + 7.62*granola*granola <= 56, "tastiness_ramen_granola")
m.addConstr(7.25*steaks + 6.01*sandwiches <= 105, "tastiness_steaks_sandwiches")
m.addConstr(7.74*ramen + 7.25*steaks + 6.01*sandwiches + 7.62*granola <= 105, "tastiness_total")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Objective Value:', m.objVal)
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

