
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
fiber = m.addVar(name="fiber", lb=0)
vitamin_b4 = m.addVar(name="vitamin_b4", lb=0)
vitamin_b5 = m.addVar(name="vitamin_b5", lb=0)

# Set objective function
m.setObjective(1 * fiber + 7 * vitamin_b4 + 5 * vitamin_b5, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(34 * vitamin_b4 + 20 * vitamin_b5 >= 103, "c0")
m.addConstr(13 * fiber + 29 * vitamin_b4 >= 59, "c1")
m.addConstr(21 * fiber + 26 * vitamin_b5 <= 353, "c2")
m.addConstr(21 * fiber + 30 * vitamin_b4 + 26 * vitamin_b5 <= 353, "c3")
m.addConstr(23 * fiber + 31 * vitamin_b5 <= 148, "c4")
m.addConstr(28 * vitamin_b4 + 31 * vitamin_b5 <= 130, "c5")
m.addConstr(23 * fiber + 28 * vitamin_b4 + 31 * vitamin_b5 <= 130, "c6")
m.addConstr(14 * fiber + 19 * vitamin_b5 <= 357, "c7")
m.addConstr(14 * fiber + 14 * vitamin_b4 <= 261, "c8")
m.addConstr(14 * fiber + 14 * vitamin_b4 + 19 * vitamin_b5 <= 261, "c9")
m.addConstr(34 * vitamin_b4 + 20 * vitamin_b5 <= 517, "c10")
m.addConstr(8 * fiber + 20 * vitamin_b5 <= 301, "c11")
m.addConstr(8 * fiber + 34 * vitamin_b4 + 20 * vitamin_b5 <= 301, "c12")
m.addConstr(13 * fiber + 29 * vitamin_b4 <= 386, "c13")
m.addConstr(13 * fiber + 15 * vitamin_b5 <= 367, "c14")
m.addConstr(13 * fiber + 29 * vitamin_b4 + 15 * vitamin_b5 <= 367, "c15")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

