
from gurobipy import *

# Create a model
model = Model("Optimization_Problem")

# Define variables
grams_of_fiber = model.addVar(lb=0, name="grams_of_fiber", vtype=GRB.CONTINUOUS)
milligrams_of_vitamin_B4 = model.addVar(lb=0, name="milligrams_of_vitamin_B4", vtype=GRB.CONTINUOUS)
milligrams_of_vitamin_B5 = model.addVar(lb=0, name="milligrams_of_vitamin_B5", vtype=GRB.CONTINUOUS)

# Objective function
model.setObjective(1 * grams_of_fiber + 7 * milligrams_of_vitamin_B4 + 5 * milligrams_of_vitamin_B5, GRB.MAXIMIZE)

# Constraints
# Cognitive performance index constraint for milligrams of vitamin B4 and B5
model.addConstr(34 * milligrams_of_vitamin_B4 + 20 * milligrams_of_vitamin_B5 >= 103, name="cognitive_performance_index_min")

# Digestive support index constraint for grams of fiber and milligrams of vitamin B4
model.addConstr(13 * grams_of_fiber + 29 * milligrams_of_vitamin_B4 >= 59, name="digestive_support_index_min_1")

# Kidney support index constraint for grams of fiber and milligrams of vitamin B5
model.addConstr(21 * grams_of_fiber + 26 * milligrams_of_vitamin_B5 <= 353, name="kidney_support_index_max_1")

# Kidney support index constraint for all variables
model.addConstr(21 * grams_of_fiber + 30 * milligrams_of_vitamin_B4 + 26 * milligrams_of_vitamin_B5 <= 353, name="kidney_support_index_max_2")

# Cardiovascular support index constraints
model.addConstr(23 * grams_of_fiber + 31 * milligrams_of_vitamin_B5 <= 148, name="cardiovascular_support_index_max_1")
model.addConstr(28 * milligrams_of_vitamin_B4 + 31 * milligrams_of_vitamin_B5 <= 130, name="cardiovascular_support_index_max_2")
model.addConstr(23 * grams_of_fiber + 28 * milligrams_of_vitamin_B4 + 31 * milligrams_of_vitamin_B5 <= 130, name="cardiovascular_support_index_max_3")

# Immune support index constraints
model.addConstr(14 * grams_of_fiber + 19 * milligrams_of_vitamin_B5 <= 357, name="immune_support_index_max_1")
model.addConstr(14 * grams_of_fiber + 14 * milligrams_of_vitamin_B4 <= 261, name="immune_support_index_max_2")
model.addConstr(14 * grams_of_fiber + 14 * milligrams_of_vitamin_B4 + 19 * milligrams_of_vitamin_B5 <= 261, name="immune_support_index_max_3")

# Cognitive performance index constraints
model.addConstr(34 * milligrams_of_vitamin_B4 + 20 * milligrams_of_vitamin_B5 <= 517, name="cognitive_performance_index_max_1")
model.addConstr(8 * grams_of_fiber + 20 * milligrams_of_vitamin_B5 <= 301, name="cognitive_performance_index_max_2")
model.addConstr(8 * grams_of_fiber + 34 * milligrams_of_vitamin_B4 + 20 * milligrams_of_vitamin_B5 <= 301, name="cognitive_performance_index_max_3")

# Digestive support index constraints
model.addConstr(13 * grams_of_fiber + 29 * milligrams_of_vitamin_B4 <= 386, name="digestive_support_index_max_1")
model.addConstr(13 * grams_of_fiber + 15 * milligrams_of_vitamin_B5 <= 367, name="digestive_support_index_max_2")
model.addConstr(13 * grams_of_fiber + 29 * milligrams_of_vitamin_B4 + 15 * milligrams_of_vitamin_B5 <= 367, name="digestive_support_index_max_3")

# Optimize model
model.optimize()

# Print results
for v in model.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", model.objVal)
