
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="grams_of_fiber", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_vitamin_B4", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_vitamin_B5", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)

# Define the objective function
m.setObjective(1 * x0 + 7 * x1 + 5 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(21 * x0 <= 365, name="kidney_support_index_fiber")
m.addConstr(23 * x0 <= 255, name="cardiovascular_support_index_fiber")
m.addConstr(14 * x0 <= 387, name="immune_support_index_fiber")
m.addConstr(8 * x0 <= 530, name="cognitive_performance_index_fiber")
m.addConstr(13 * x0 <= 396, name="digestive_support_index_fiber")

m.addConstr(30 * x1 <= 365, name="kidney_support_index_B4")
m.addConstr(28 * x1 <= 255, name="cardiovascular_support_index_B4")
m.addConstr(14 * x1 <= 387, name="immune_support_index_B4")
m.addConstr(34 * x1 <= 530, name="cognitive_performance_index_B4")
m.addConstr(29 * x1 <= 396, name="digestive_support_index_B4")

m.addConstr(26 * x2 <= 365, name="kidney_support_index_B5")
m.addConstr(31 * x2 <= 255, name="cardiovascular_support_index_B5")
m.addConstr(19 * x2 <= 387, name="immune_support_index_B5")
m.addConstr(20 * x2 <= 530, name="cognitive_performance_index_B5")
m.addConstr(15 * x2 <= 396, name="digestive_support_index_B5")

m.addConstr(34 * x1 + 20 * x2 >= 103, name="cognitive_performance_index_B4_B5")
m.addConstr(13 * x0 + 29 * x1 >= 59, name="digestive_support_index_fiber_B4")
m.addConstr(21 * x0 + 26 * x2 <= 353, name="kidney_support_index_fiber_B5")
m.addConstr(21 * x0 + 30 * x1 + 26 * x2 <= 353, name="kidney_support_index_fiber_B4_B5")
m.addConstr(23 * x0 + 31 * x2 <= 148, name="cardiovascular_support_index_fiber_B5")
m.addConstr(28 * x1 + 31 * x2 <= 130, name="cardiovascular_support_index_B4_B5")
m.addConstr(23 * x0 + 28 * x1 + 31 * x2 <= 130, name="cardiovascular_support_index_fiber_B4_B5")
m.addConstr(14 * x0 + 19 * x2 <= 357, name="immune_support_index_fiber_B5")
m.addConstr(14 * x0 + 14 * x1 <= 261, name="immune_support_index_fiber_B4")
m.addConstr(14 * x0 + 14 * x1 + 19 * x2 <= 261, name="immune_support_index_fiber_B4_B5")
m.addConstr(34 * x1 + 20 * x2 <= 517, name="cognitive_performance_index_B4_B5_2")
m.addConstr(8 * x0 + 20 * x2 <= 301, name="cognitive_performance_index_fiber_B5")
m.addConstr(8 * x0 + 34 * x1 + 20 * x2 <= 301, name="cognitive_performance_index_fiber_B4_B5")
m.addConstr(13 * x0 + 29 * x1 <= 386, name="digestive_support_index_fiber_B4_2")
m.addConstr(13 * x0 + 15 * x2 <= 367, name="digestive_support_index_fiber_B5_2")
m.addConstr(13 * x0 + 29 * x1 + 15 * x2 <= 367, name="digestive_support_index_fiber_B4_B5")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Grams of fiber:", x0.varValue)
    print("Milligrams of vitamin B4:", x1.varValue)
    print("Milligrams of vitamin B5:", x2.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
