
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B3")
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_fiber")
x2 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_K")
x3 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")

# Define the objective function
m.setObjective(4.8*x0**2 + 2.12*x0*x1 + 6.97*x0*x2 + 8.25*x1**2 + 7.81*x1*x2 + 3.96*x0 + 8.16*x1 + 7.57*x3, GRB.MINIMIZE)

# Add the constraints
m.addConstr(x0 + 5*x1 + 2*x2 + 2*x3 <= 76, name="cardiovascular_support_index")
m.addConstr(x0 + x2 >= 17, name="vitamin_B3_and_vitamin_K_index")
m.addConstr(x2**2 + x3**2 >= 17, name="vitamin_K_squared_and_carbohydrates_squared_index")
m.addConstr(x0 + x1 >= 12, name="vitamin_B3_and_fiber_index")
m.addConstr(x0 + x1 + x2 + x3 >= 12, name="total_combined_cardiovascular_support_index")
m.addConstr(-5*x0 + 3*x1 >= 0, name="constraint_1")
m.addConstr(-x0**2 + 2*x2**2 >= 0, name="constraint_2")
m.addConstr(-2*x1 + 5*x2 + 2*x3 >= 0, name="constraint_3")
m.addConstr(x0 + x3 <= 29, name="vitamin_B3_and_carbohydrates_index_max")
m.addConstr(x0 + x1 <= 23, name="vitamin_B3_and_fiber_index_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("milligrams_of_vitamin_B3:", x0.x)
    print("grams_of_fiber:", x1.x)
    print("milligrams_of_vitamin_K:", x2.x)
    print("grams_of_carbohydrates:", x3.x)
else:
    print("No optimal solution found.")
