
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("work_optimization")

    # Create variables
    bill_hours = m.addVar(name="bill_hours")
    ringo_hours = m.addVar(name="ringo_hours")
    bobby_hours = m.addVar(name="bobby_hours")
    jean_hours = m.addVar(name="jean_hours")

    # Set objective function
    m.setObjective(8.78 * bill_hours**2 + 3.25 * bill_hours * jean_hours + 2.78 * bobby_hours * jean_hours + 6.85 * ringo_hours + 5.71 * bobby_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    work_quality = {'Bill': 10, 'Ringo': 19, 'Bobby': 14, 'Jean': 10}
    likelihood_to_quit = {'Bill': 15, 'Ringo': 17, 'Bobby': 15, 'Jean': 20}
    organization_score = {'Bill': 16, 'Ringo': 21, 'Bobby': 16, 'Jean': 3}

    m.addConstr(work_quality['Bobby'] * bobby_hours + work_quality['Jean'] * jean_hours >= 32)
    m.addConstr(work_quality['Bill'] * bill_hours + work_quality['Bobby'] * bobby_hours >= 72)
    m.addConstr(work_quality['Ringo'] * ringo_hours + work_quality['Bobby'] * bobby_hours >= 68)
    m.addConstr(work_quality['Ringo'] * ringo_hours + work_quality['Bobby'] * bobby_hours + work_quality['Jean'] * jean_hours >= 88)
    m.addConstr(work_quality['Bill'] * bill_hours + work_quality['Bobby'] * bobby_hours + work_quality['Jean'] * jean_hours >= 88)
    m.addConstr(work_quality['Bill'] * bill_hours + work_quality['Ringo'] * ringo_hours + work_quality['Bobby'] * bobby_hours >= 88)
    m.addConstr(work_quality['Ringo'] * ringo_hours + work_quality['Bobby'] * bobby_hours + work_quality['Jean'] * jean_hours >= 57)
    m.addConstr(work_quality['Bill'] * bill_hours + work_quality['Bobby'] * bobby_hours + work_quality['Jean'] * jean_hours >= 57)
    m.addConstr(work_quality['Bill'] * bill_hours + work_quality['Ringo'] * ringo_hours + work_quality['Bobby'] * bobby_hours >= 57)

    # ... (Rest of the constraints implemented similarly)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Bill Hours: %g' % bill_hours.x)
        print('Ringo Hours: %g' % ringo_hours.x)
        print('Bobby Hours: %g' % bobby_hours.x)
        print('Jean Hours: %g' % jean_hours.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
