
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
B = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Bill")
R = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Ringo")
Bo = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Bobby")
J = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="hours_worked_by_Jean")

# Define the objective function
m.setObjective(8.78 * B**2 + 3.25 * B * J + 2.78 * Bo * J + 6.85 * R + 5.71 * Bo, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*B + 19*R + 14*Bo + 10*J <= 362)
m.addConstr(15*B + 17*R + 15*Bo + 20*J <= 185)
m.addConstr(16*B + 21*R + 16*Bo + 3*J <= 374)
m.addConstr(14*Bo + 10*J >= 32)
m.addConstr(10*B + 14*Bo >= 72)
m.addConstr(19*R + 14*Bo >= 68)
m.addConstr(19*R + 14*Bo + 10*J >= 88)
m.addConstr(10*B + 14*Bo + 10*J >= 88)
m.addConstr(19*R + 14*Bo + 10*J >= 57)
m.addConstr(10*B + 14*Bo + 10*J >= 57)
m.addConstr(10*B + 19*R + 14*Bo >= 57)
m.addConstr(19**2*R**2 + 14**2*Bo**2 + 10**2*J**2 >= 83)
m.addConstr(10**2*B**2 + 14**2*Bo**2 + 10**2*J**2 >= 83)
m.addConstr(10*B + 19*R + 14*Bo >= 83)
m.addConstr(10*B + 10*J <= 283)
m.addConstr(19*R + 10*J <= 331)
m.addConstr(19*R + 14*Bo <= 105)
m.addConstr(10*B + 14*Bo <= 161)
m.addConstr(10**2*B**2 + 14**2*Bo**2 + 10**2*J**2 <= 210)
m.addConstr(10*B + 19*R + 14*Bo <= 216)
m.addConstr(19**2*R**2 + 14**2*Bo**2 + 10**2*J**2 <= 253)
m.addConstr(10*B + 19*R + 14*Bo + 10*J <= 253)
m.addConstr(15**2*B**2 + 17**2*R**2 <= 62)
m.addConstr(17**2*R**2 + 15**2*Bo**2 <= 159)
m.addConstr(15*Bo + 20*J <= 60)
m.addConstr(15*B + 15*Bo <= 153)
m.addConstr(15**2*B**2 + 17**2*R**2 + 15**2*Bo**2 <= 146)
m.addConstr(15*B + 17*R + 15*Bo + 20*J <= 146)
m.addConstr(21*R + 3*J <= 333)
m.addConstr(21**2*R**2 + 16**2*Bo**2 <= 149)
m.addConstr(16*B + 16*Bo <= 240)
m.addConstr(16*B + 21*R + 16*Bo + 3*J <= 240)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("hours_worked_by_Bill: ", B.varValue)
    print("hours_worked_by_Ringo: ", R.varValue)
    print("hours_worked_by_Bobby: ", Bo.varValue)
    print("hours_worked_by_Jean: ", J.varValue)
else:
    print("The model is infeasible")
