
from gurobipy import Model, GRB

# Create a new model
model = Model("vitamin_optimization")

# Create variables
b7 = model.addVar(lb=0, name="B7")  # milligrams of vitamin B7
b12 = model.addVar(lb=0, name="B12") # milligrams of vitamin B12

# Set objective function
model.setObjective(1 * b7 + 4 * b12, GRB.MAXIMIZE)

# Add constraints

# Resource constraints (implicit from individual contributions and total constraints)
# Immune support
model.addConstr(18 * b7 + 23 * b12 >= 27, "immune_support_min")
model.addConstr(18 * b7 + 23 * b12 <= 89, "immune_support_max") # Two identical constraints combined

# Cognitive performance
model.addConstr(8 * b7 + 29 * b12 >= 51, "cognitive_performance_min")
model.addConstr(8 * b7 + 29 * b12 <= 191, "cognitive_performance_max") # Two identical constraints combined


# Digestive support
model.addConstr(15 * b7 + 21 * b12 >= 51, "digestive_support_min")
model.addConstr(15 * b7 + 21 * b12 <= 88, "digestive_support_max") # Two identical constraints combined

# Kidney support
model.addConstr(3 * b7 + 17 * b12 >= 27, "kidney_support_min")
model.addConstr(3 * b7 + 17 * b12 <= 71, "kidney_support_max") # Two identical constraints combined

# Energy stability
model.addConstr(20 * b7 + 22 * b12 >= 18, "energy_stability_min")
model.addConstr(20 * b7 + 22 * b12 <= 52, "energy_stability_max") # Two identical constraints combined

# Additional constraint
model.addConstr(3 * b7 - 7 * b12 >= 0, "additional_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {model.objVal}")
    print(f"B7: {b7.x}")
    print(f"B12: {b12.x}")
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status: {model.status}")

