
from gurobipy import *

# Create a model
m = Model("Vitamins_Optimization")

# Define variables
x0 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B7")
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B12")

# Set objective function
m.setObjective(1*x0 + 4*x1, GRB.MAXIMIZE)

# Add constraints
# Minimum total combined indices
m.addConstr(18*x0 + 23*x1 >= 27, "immune_support_index_min")
m.addConstr(8*x0 + 29*x1 >= 51, "cognitive_performance_index_min")
m.addConstr(15*x0 + 21*x1 >= 51, "digestive_support_index_min")
m.addConstr(3*x0 + 17*x1 >= 27, "kidney_support_index_min")
m.addConstr(20*x0 + 22*x1 >= 18, "energy_stability_index_min")

# Linear combination constraint
m.addConstr(3*x0 - 7*x1 >= 0, "linear_combination_constraint")

# Maximum total combined indices
m.addConstr(18*x0 + 23*x1 <= 89, "immune_support_index_max")
m.addConstr(8*x0 + 29*x1 <= 191, "cognitive_performance_index_max")
m.addConstr(15*x0 + 21*x1 <= 88, "digestive_support_index_max")
m.addConstr(3*x0 + 17*x1 <= 71, "kidney_support_index_max")
m.addConstr(20*x0 + 22*x1 <= 52, "energy_stability_index_max")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B7: {x0.x}")
    print(f"Milligrams of Vitamin B12: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
