
import gurobi

def optimize_vitamins():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="milligrams of vitamin B7", lb=0)  # No lower bound specified, assuming 0
    x1 = model.addVar(name="milligrams of vitamin B12", lb=0)  # No lower bound specified, assuming 0

    # Objective function: maximize 1 * x0 + 4 * x1
    model.setObjective(x0 + 4 * x1, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(18 * x0 + 23 * x1 >= 27, name="immune_support_index_min")
    model.addConstr(8 * x0 + 29 * x1 >= 51, name="cognitive_performance_index_min")
    model.addConstr(15 * x0 + 21 * x1 >= 51, name="digestive_support_index_min")
    model.addConstr(3 * x0 + 17 * x1 >= 27, name="kidney_support_index_min")
    model.addConstr(20 * x0 + 22 * x1 >= 18, name="energy_stability_index_min")
    model.addConstr(3 * x0 - 7 * x1 >= 0, name="linear_constraint")
    model.addConstr(18 * x0 + 23 * x1 <= 89, name="immune_support_index_max")
    model.addConstr(8 * x0 + 29 * x1 <= 191, name="cognitive_performance_index_max")
    model.addConstr(15 * x0 + 21 * x1 <= 88, name="digestive_support_index_max")
    model.addConstr(3 * x0 + 17 * x1 <= 71, name="kidney_support_index_max")
    model.addConstr(20 * x0 + 22 * x1 <= 52, name="energy_stability_index_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B7: {x0.varValue}")
        print(f"Milligrams of vitamin B12: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
