
import gurobi as gp

# Define variables
model = gp.Model("optimization_problem")

# Variables
bowls_of_pasta = model.addVar(name="bowls_of_pasta", vtype=gp.GRB.INTEGER)
steaks = model.addVar(name="steaks", vtype=gp.GRB.INTEGER)
strawberries = model.addVar(name="strawberries", vtype=gp.GRB.INTEGER)
ravioli = model.addVar(name="ravioli", vtype=gp.GRB.INTEGER)
slices_of_pizza = model.addVar(name="slices_of_pizza", vtype=gp.GRB.INTEGER)
eggs = model.addVar(name="eggs", vtype=gp.GRB.INTEGER)
cherry_pies = model.addVar(name="cherry_pies", vtype=gp.GRB.INTEGER)

# Objective function coefficients
obj_coeffs = {
    "bowls_of_pasta": 2.93,
    "steaks": 9.39,
    "strawberries": 2.32,
    "ravioli": 8.75,
    "slices_of_pizza": 6.23,
    "eggs": 4.52,
    "cherry_pies": 1.54,
}

# Objective function
model.setObjective(
    obj_coeffs["bowls_of_pasta"] * bowls_of_pasta
    + obj_coeffs["steaks"] * steaks
    + obj_coeffs["strawberries"] * strawberries
    + obj_coeffs["ravioli"] * ravioli
    + obj_coeffs["slices_of_pizza"] * slices_of_pizza
    + obj_coeffs["eggs"] * eggs
    + obj_coeffs["cherry_pies"] * cherry_pies,
    gp.GRB.MINIMIZE,
)

# Constraints
# Iron content per item
iron_content = {
    "bowls_of_pasta": 3.78,
    "steaks": 5.09,
    "strawberries": 8.37,
    "ravioli": 6.04,
    "slices_of_pizza": 5.1,
    "eggs": 1.02,
    "cherry_pies": 2.68,
}

# Constraints for iron intake from specific combinations of food items
model.addConstr(iron_content["strawberries"] * strawberries + iron_content["cherry_pies"] * cherry_pies >= 45)
model.addConstr(iron_content["slices_of_pizza"] * slices_of_pizza + iron_content["cherry_pies"] * cherry_pies >= 44)
model.addConstr(iron_content["eggs"] * eggs + iron_content["cherry_pies"] * cherry_pies >= 64)
model.addConstr(iron_content["strawberries"] * strawberries + iron_content["eggs"] * eggs >= 71)

# ... add all other constraints similarly

# Example constraint: -2 * strawberries + 8 * slices_of_pizza >= 0
model.addConstr(-2 * strawberries + 8 * slices_of_pizza >= 0)

# Example constraint: ravioli + eggs <= 371 / iron_content["ravioli"] + iron_content["eggs"]
model.addConstr(iron_content["ravioli"] * ravioli + iron_content["eggs"] * eggs <= 371)

# ... add all other constraints

# Bounds for iron intake from specific combinations of food items
model.addConstr(iron_content["steaks"] * steaks + iron_content["slices_of_pizza"] * slices_of_pizza <= 223)
model.addConstr(iron_content["steaks"] * steaks + iron_content["strawberries"] * strawberries <= 215)
model.addConstr(iron_content["ravioli"] * ravioli + iron_content["slices_of_pizza"] * slices_of_pizza <= 347)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("bowls_of_pasta: ", bowls_of_pasta.varValue)
    print("steaks: ", steaks.varValue)
    print("strawberries: ", strawberries.varValue)
    print("ravioli: ", ravioli.varValue)
    print("slices_of_pizza: ", slices_of_pizza.varValue)
    print("eggs: ", eggs.varValue)
    print("cherry_pies: ", cherry_pies.varValue)
else:
    print("No optimal solution found")
