
from gurobipy import Model, GRB

# Create a new model
m = Model("work_optimization")

# Create variables
jean_hours = m.addVar(vtype=GRB.INTEGER, name="jean_hours")
george_hours = m.addVar(vtype=GRB.INTEGER, name="george_hours")

# Set objective function
m.setObjective(8.61*jean_hours**2 + 8.54*jean_hours*george_hours + 1.04*george_hours**2 + 3.32*jean_hours + 8.36*george_hours, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*jean_hours**2 + 6*george_hours**2 >= 49, "c1")
m.addConstr(3*jean_hours**2 - 9*george_hours**2 >= 0, "c2")
m.addConstr(17*jean_hours + 6*george_hours <= 152, "c3") # Combined work quality rating <= 152
m.addConstr(17*jean_hours + 6*george_hours == 152, "c4") # Combined work quality rating == 152


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Jean Hours: %g' % jean_hours.x)
    print('George Hours: %g' % george_hours.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
