
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_jean = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_jean")
hours_worked_by_george = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_george")

# Objective function: maximize
m.setObjective(8.61 * hours_worked_by_jean**2 + 8.54 * hours_worked_by_jean * hours_worked_by_george + 
               1.04 * hours_worked_by_george**2 + 3.32 * hours_worked_by_jean + 8.36 * hours_worked_by_george, GRB.MAXIMIZE)

# Constraints
m.addConstr(17 * hours_worked_by_jean == 17 * hours_worked_by_jean)  # This constraint is always true and does not affect the model
m.addConstr(6 * hours_worked_by_george == 6 * hours_worked_by_george)  # Similarly, this constraint is redundant
m.addConstr(hours_worked_by_jean**2 + hours_worked_by_george**2 >= 49)
m.addConstr(3 * hours_worked_by_jean**2 - 9 * hours_worked_by_george**2 >= 0)
m.addConstr(17 * hours_worked_by_jean + 6 * hours_worked_by_george == 152)  # Combined work quality rating constraint

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Jean: {hours_worked_by_jean.x}")
    print(f"Hours worked by George: {hours_worked_by_george.x}")
else:
    print("No optimal solution found")
