
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    jean_hours = model.addVar(name="jean_hours", vtype=gurobi.GRB.INTEGER)
    george_hours = model.addVar(name="george_hours", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8.61 * jean_hours**2 + 8.54 * jean_hours * george_hours + 1.04 * george_hours**2 + 3.32 * jean_hours + 8.36 * george_hours, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(jean_hours, gurobi.GRB.EQUAL, 17, "jean_work_quality")
    model.addConstr(george_hours, gurobi.GRB.EQUAL, 6, "george_work_quality")
    model.addConstr(jean_hours**2 + george_hours**2, gurobi.GRB.GREATER_EQUAL, 49, "min_work_quality_squared")
    model.addConstr(3 * jean_hours**2 - 9 * george_hours**2, gurobi.GRB.GREATER_EQUAL, 0, "quality_constraint")
    model.addConstr(jean_hours + george_hours, gurobi.GRB.LESS_EQUAL, 152, "max_work_quality")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Jean's hours: {jean_hours.varValue}")
        print(f"George's hours: {george_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

optimization_problem()
