
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
oreos = m.addVar(lb=0, name="oreos")
protein_bars = m.addVar(lb=0, name="protein_bars")
ramen = m.addVar(lb=0, name="ramen")
tomatoes = m.addVar(lb=0, name="tomatoes")

# Set objective function
m.setObjective(2 * oreos + 6 * protein_bars + 6 * ramen + 1 * tomatoes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(7 * oreos + 1 * tomatoes >= 53, "health_oreos_tomatoes_min")
m.addConstr(7 * oreos + 6 * ramen >= 43, "health_oreos_ramen_min")
m.addConstr(7 * oreos + 11 * protein_bars >= 47, "health_oreos_protein_bars_min")
m.addConstr(11 * protein_bars + 1 * tomatoes >= 52, "health_protein_bars_tomatoes_min")
m.addConstr(7 * oreos + 11 * protein_bars + 6 * ramen + 1 * tomatoes >= 52, "health_total_min")

m.addConstr(4 * oreos + 25 * protein_bars >= 18, "carbs_oreos_protein_bars_min")
m.addConstr(4 * oreos + 25 * protein_bars + 26 * ramen + 29 * tomatoes >= 18, "carbs_total_min")

m.addConstr(7 * oreos + 6 * ramen <= 168, "health_oreos_ramen_max")
m.addConstr(7 * oreos + 1 * tomatoes <= 109, "health_oreos_tomatoes_max")

m.addConstr(4 * oreos + 26 * ramen + 29 * tomatoes <= 86, "carbs_oreos_ramen_tomatoes_max")
m.addConstr(4 * oreos + 25 * protein_bars + 26 * ramen <= 48, "carbs_oreos_protein_bars_ramen_max")

m.addConstr(7 * oreos + 11 * protein_bars + 6 * ramen + 1 * tomatoes <= 217, "health_total_max")
m.addConstr(4 * oreos + 25 * protein_bars + 26 * ramen + 29 * tomatoes <= 125, "carbs_total_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

