
import gurobi

# Create a new Gurobi model
model = gurobi.Model()

# Define the variables
oreos = model.addVar(name="oreos", lb=0)
protein_bars = model.addVar(name="protein_bars", lb=0)
bowls_of_instant_ramen = model.addVar(name="bowls_of_instant_ramen", lb=0)
tomatoes = model.addVar(name="tomatoes", lb=0)

# Define the objective function
model.setObjective(2 * oreos + 6 * protein_bars + 6 * bowls_of_instant_ramen + tomatoes, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstraint(7 * oreos + tomatoes >= 53, name="healthiness_oreos_tomatoes")
model.addConstraint(7 * oreos + 6 * bowls_of_instant_ramen >= 43, name="healthiness_oreos_ramen")
model.addConstraint(7 * oreos + 11 * protein_bars >= 47, name="healthiness_oreos_protein")
model.addConstraint(11 * protein_bars + tomatoes >= 52, name="healthiness_protein_tomatoes")
model.addConstraint(7 * oreos + 11 * protein_bars + 6 * bowls_of_instant_ramen + tomatoes >= 52, name="healthiness_total")
model.addConstraint(7 * oreos + 6 * bowls_of_instant_ramen <= 168, name="healthiness_oreos_ramen_max")
model.addConstraint(7 * oreos + tomatoes <= 109, name="healthiness_oreos_tomatoes_max")
model.addConstraint(4 * oreos + 25 * protein_bars >= 18, name="carbohydrates_oreos_protein")
model.addConstraint(4 * oreos + 25 * protein_bars + 26 * bowls_of_instant_ramen + 29 * tomatoes >= 18, name="carbohydrates_total")
model.addConstraint(4 * oreos + 26 * bowls_of_instant_ramen + 29 * tomatoes <= 86, name="carbohydrates_oreos_ramen_tomatoes")
model.addConstraint(4 * oreos + 25 * protein_bars + 26 * bowls_of_instant_ramen <= 48, name="carbohydrates_oreos_protein_ramen")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Oreos: ", oreos.x)
    print("Protein Bars: ", protein_bars.x)
    print("Bowls of Instant Ramen: ", bowls_of_instant_ramen.x)
    print("Tomatoes: ", tomatoes.x)
else:
    print("The model is infeasible")
