
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    carbs = m.addVar(vtype=gp.GRB.INTEGER, name="carbs")
    protein = m.addVar(vtype=gp.GRB.INTEGER, name="protein")
    vit_b1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vit_b1")
    vit_b7 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vit_b7")
    vit_d = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vit_d")

    # Set objective function
    m.setObjective(6*carbs + 6*protein + 2*vit_b1 + 2*vit_b7 + 4*vit_d, gp.GRB.MAXIMIZE)

    # Resource constraints
    resources = {
        'r0': {'upper_bound': 371, 'coeffs': [16, 13, 5, 11, 10]},
        'r1': {'upper_bound': 186, 'coeffs': [13, 3, 1, 14, 14]},
        'r2': {'upper_bound': 409, 'coeffs': [11, 12, 15, 4, 5]},
        'r3': {'upper_bound': 409, 'coeffs': [8, 13, 7, 10, 5]}
    }

    for r_name, r_data in resources.items():
        m.addConstr(
            r_data['coeffs'][0]*carbs + r_data['coeffs'][1]*protein + r_data['coeffs'][2]*vit_b1 + r_data['coeffs'][3]*vit_b7 + r_data['coeffs'][4]*vit_d <= r_data['upper_bound'],
            name=f"{r_name}_constraint"
        )


    # Add your additional constraints here, following the same pattern as above.
    # For example:
    # m.addConstr(16*carbs + 13*protein + 10*vit_d >= 40, "immune_support_1")
    # ... and so on for all your constraints

    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
