
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_b9 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b9")
calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
vitamin_b3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b3")
vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")

# Set objective function
m.setObjective(9 * vitamin_b9 + 3 * calcium + 8 * vitamin_b3 + 4 * vitamin_b2, gp.GRB.MINIMIZE)

# Add constraints based on resource indices
kidney_support = {
    "vitamin_b9": 7,
    "calcium": 4,
    "vitamin_b3": 10,
    "vitamin_b2": 6,
    "upper_bound": 296
}
muscle_growth = {
    "vitamin_b9": 2,
    "calcium": 5,
    "vitamin_b3": 1,
    "vitamin_b2": 1,
    "upper_bound": 253
}
energy_stability = {
    "vitamin_b9": 11,
    "calcium": 3,
    "vitamin_b3": 2,
    "vitamin_b2": 10,
    "upper_bound": 70
}


# Kidney support constraints
m.addConstr(4 * calcium + 6 * vitamin_b2 >= 60)
m.addConstr(7 * vitamin_b9 + 6 * vitamin_b2 >= 35)
m.addConstr(7 * vitamin_b9 + 10 * vitamin_b3 >= 67)
m.addConstr(4 * calcium + 10 * vitamin_b3 >= 24)
m.addConstr(7 * vitamin_b9 + 4 * calcium + 6 * vitamin_b2 >= 73)
m.addConstr(7 * vitamin_b9 + 10 * vitamin_b3 + 6 * vitamin_b2 >= 73)
m.addConstr(4 * calcium + 10 * vitamin_b3 + 6 * vitamin_b2 >= 73)
m.addConstr(7 * vitamin_b9 + 4 * calcium + 6 * vitamin_b2 >= 56)
m.addConstr(7 * vitamin_b9 + 10 * vitamin_b3 + 6 * vitamin_b2 >= 56)
m.addConstr(4 * calcium + 10 * vitamin_b3 + 6 * vitamin_b2 >= 56)
m.addConstr(7 * vitamin_b9 + 4 * calcium + 6 * vitamin_b2 >= 47)
m.addConstr(7 * vitamin_b9 + 10 * vitamin_b3 + 6 * vitamin_b2 >= 47)
m.addConstr(4 * calcium + 10 * vitamin_b3 + 6 * vitamin_b2 >= 47)
m.addConstr(7 * vitamin_b9 + 4 * calcium + 10 * vitamin_b3 + 6 * vitamin_b2 >= 47)


# Muscle growth constraints
m.addConstr(2 * vitamin_b9 + 1 * vitamin_b3 >= 30)
m.addConstr(2 * vitamin_b9 + 1 * vitamin_b2 >= 37)
m.addConstr(2 * vitamin_b9 + 5 * calcium + 1 * vitamin_b2 >= 41)
m.addConstr(2 * vitamin_b9 + 5 * calcium + 1 * vitamin_b3 + 1 * vitamin_b2 >= 41)

# Energy stability constraints
m.addConstr(3 * calcium + 2 * vitamin_b3 >= 15)
m.addConstr(11 * vitamin_b9 + 10 * vitamin_b2 >= 7)
m.addConstr(11 * vitamin_b9 + 3 * calcium >= 10)
m.addConstr(3 * calcium + 2 * vitamin_b3 + 10 * vitamin_b2 >= 12)
m.addConstr(11 * vitamin_b9 + 3 * calcium + 2 * vitamin_b3 >= 12)
m.addConstr(3 * calcium + 2 * vitamin_b3 + 10 * vitamin_b2 >= 12)
m.addConstr(11 * vitamin_b9 + 3 * calcium + 2 * vitamin_b3 >= 12)
m.addConstr(11 * vitamin_b9 + 3 * calcium + 2 * vitamin_b3 + 10 * vitamin_b2 >= 12)

# Additional constraints
m.addConstr(4 * vitamin_b9 - 6 * calcium >= 0)
m.addConstr(4 * calcium - 4 * vitamin_b3 >= 0)

# Upper bound constraints
m.addConstr(4 * calcium + 10 * vitamin_b3 <= 265)
m.addConstr(7 * vitamin_b9 + 6 * vitamin_b2 <= 114)
m.addConstr(10 * vitamin_b3 + 6 * vitamin_b2 <= 142)
m.addConstr(5 * calcium + 1 * vitamin_b3 <= 236)
m.addConstr(2 * vitamin_b9 + 1 * vitamin_b3 <= 196)
m.addConstr(5 * calcium + 1 * vitamin_b2 <= 133)
m.addConstr(11 * vitamin_b9 + 2 * vitamin_b3 <= 20)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

