
from gurobipy import Model, GRB

# Create a new model
m = Model("food_optimization")

# Create variables
potatoes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")
protein_bars = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="protein_bars")

# Set objective function
m.setObjective(5 * potatoes + 2 * protein_bars, GRB.MINIMIZE)

# Add constraints
m.addConstr(5 * potatoes + 7 * protein_bars >= 31, "healthiness_min")
m.addConstr(2 * potatoes + 1 * protein_bars >= 20, "tastiness_min")
m.addConstr(8 * potatoes + 10 * protein_bars >= 24, "fiber_min")
m.addConstr(9 * potatoes - 1 * protein_bars >= 0, "potato_protein_relation")
m.addConstr(5 * potatoes + 7 * protein_bars <= 52, "healthiness_max")  # Redundant given healthiness_min
m.addConstr(2 * potatoes + 1 * protein_bars <= 50, "tastiness_max")  # Redundant given tastiness_min
m.addConstr(8 * potatoes + 10 * protein_bars <= 30, "fiber_max")  # Redundant given fiber_min


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('potatoes:', potatoes.x)
    print('protein_bars:', protein_bars.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

